definition module StdFont


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdFont contains the font definitions.
//	********************************************************************************


from	osfont	import Font
import	StdFontDef


class FontEnv env where
	openFont			::			 !FontDef	!*env -> (!(!Bool,!Font),!*env)
	openDefaultFont		::						!*env -> (!Font,		 !*env)
	openDialogFont		::						!*env -> (!Font,		 !*env)
	
	getFontNames		::						!*env -> (![FontName],	 !*env)
	getFontStyles		::			 !FontName	!*env -> (![FontStyle],	 !*env)
	getFontSizes		:: !Int !Int !FontName	!*env -> (![FontSize],	 !*env)
	
	getFontCharWidth	:: ! Char	 !Font		!*env -> (!Int,			 !*env)
	getFontCharWidths	:: ![Char]	 !Font		!*env -> (![Int],		 !*env)
	getFontStringWidth	:: ! String	 !Font		!*env -> (!Int,			 !*env)
	getFontStringWidths	:: ![String] !Font		!*env -> (![Int],		 !*env)
	
	getFontMetrics		::			 !Font		!*env -> (!FontMetrics,	 !*env)
/*	openFont
		creates the font as specified by the name, stylistic variations, and size. 
		The Boolean result is True only if the font is available and need not be 
		scaled. 
		In all other cases, an existing font is returned (depending on the system).
	openDefaultFont
		returns the font used by default by applications. 
	openDialogFont
		returns the font used by default by the system.
	
	getFontNames
		returns the FontNames  of all available fonts.
	getFontStyles
		returns the FontStyles of all available styles of a particular FontName.
	getFontSizes
		returns all FontSizes in increasing order of a particular FontName that are 
		available without scaling. The sizes inspected are inclusive between the two
		Integer arguments. (Negative values are set to zero.) 
		In case the requested font is unavailable, the styles or sizes of the 
		default font are returned.
	
	getFont(Char/String)Width(s)
		return the width(s) in terms of pixels of given character(s) (string(s)) for
		a particular Font.
	
	getFontMetrics
		returns the metrics of a given Font in terms of pixels. 
*/

instance FontEnv World

getFontDef :: !Font -> FontDef
/*	getFontDef returns the name, stylistic variations and size of the argument Font.
*/
